import argparse
 
def parse_arguments():
    parser = argparse.ArgumentParser(description='DeepCamera 2x Super Resolution',
                                     formatter_class=argparse.ArgumentDefaultsHelpFormatter)


    parser.add_argument('-i','--input_file', type=str, help='The path to the video to process.')
    parser.add_argument('-o', '--output_file', type=str, help='Where to store the upsampled video.')
    parser.add_argument('-u', '--url', type=str, help='The URL of the inference server (E.G., http://192.134.1.2/).')
    parser.add_argument('--size', type=str, default="1080p", help='The size of the input video frame (720p, 1080p).')
    parser.add_argument('--pixel_format', type=str, default="yuv420p10le",help='The YUV format of the video, the supported format can be seen here: https://github.com/labradon/yuvio')
    parser.add_argument('--model', type=str, default='hd24k_standard', help='Which Model to use, 4 model are provided (hd24k_full, hd24k_standard, sd2hd_full, sd2hd_standard).')

    args = parser.parse_args()
    return args